# Flask-Login
https://www.freecodecamp.org/news/how-to-setup-user-authentication-in-flask/
https://github.com/ashutoshkrris/Flask-User-Authentication/tree/main
Note: Website styles based on Bootstrap5.2 see: https://getbootstrap.com/

This application has largely been based on the above tutorial but customized with the following characteristics:
 - There are three basic roles: public_viewer (no registration), the registered user and the administrator
 - only the admin user can register users
 - more than one admin can be created - these have access to register and/or delete users
 - the registered user has access to private pages whereas the non-registered user all the public pages.
 - current setup links to a Sqlite database but 

# Install
 - python3 -m venv .venv
 - . .venv/bin/activate
 - pip install -r requirements.txt
 

# To Start
 - . .venv/bin/activate  [or activate whatever your virtualenv is called]
 - export FLASK_APP=src
 - python3 manage.py run  [user: admin@abc.com passwd: a1234s and regular user: carol@abc.com passwd: a1234s ]
 
# To establish the admin user(s)
 - python3 manage.py create_admin  [recommend a strong 8+ character/digit password] repeat, if more than one admin is needed.
 - having established a new admin user, delete admin@abc.com
 - the new admin user can register users via the registration page.

# To deploy use uWSGI and modify flklogin.service with the correct path.
uwsgi --socket 0.0.0.0:5000 --protocol=http -w wsgi:app

# Apache2
sudo a2enmod proxy
sudo a2enmod proxy_uwsgi
=== in config file:
ProxyPass / unix:/home/sammy/flklogin/flklogin.sock|uwsgi://uwsgi-uds-app1/
