from flask import Blueprint, render_template, redirect, request, url_for
from flask_login import login_required
from src import db
from src.accounts.models import User

core_bp = Blueprint("core", __name__)

@core_bp.route("/")
@login_required
def home():
    return render_template("core/index.html")
    
@core_bp.route("/priv1")
@login_required
def priv1():
    return render_template("core/priv1.html")
    
@core_bp.route("/admin", methods=["GET","POST"])
@login_required
def admin():
    users = User.query.all()
    return render_template("core/admin.html", users=users)
    
@core_bp.route("/delete/<int:id>", methods=["POST"])
def delete(id):
    user = User.query.get(id)
    if user is None:
        return render_template("errors/404.html")
    db.session.delete(user)
    db.session.commit()
    return redirect(url_for("core.admin"))
