# sv

Everything you need to build a Svelte project, powered by [`sv`](https://github.com/sveltejs/cli).

## Creating a project

If you're seeing this, you've probably already done this step. Congrats!

```sh
# create a new project in the current directory
npx sv create

# create a new project in my-app
npx sv create my-app
```

## Developing this app: handbk
Correct permissions:
chmod -R 744 handbk
cd handbk
chmod -R 776 .svelte-kit

Once you've created a project and installed dependencies with `npm install` (or `pnpm install` or `yarn`), start a development server:
Or with Bun: bun install
Then, as it has a Pg database: bun run db:start

```sh
npm run dev
Or with Bun: bun run dev 

# or start the server and open the app in a new browser tab
npm run dev
Or with Bun: bun run dev
```

## Building

To create a production version of your app:

```sh
npm run build
Or with Bun: bun run build
```

You can preview the production build with `npm run preview`.
Or with Bun: bun run preview

> To deploy your app, you may need to install an [adapter](https://svelte.dev/docs/kit/adapters) for your target environment.
This app uses: '@sveltejs/adapter-node'

## Final Configurations
a. In file: src/lib/components/NavMain.svelte
this line:     import '/home/sammy/svelte/handbk/src/app.css';
should be changed to match one's own home user and directories.
b. In files: svelte.config.js and vite.config.ts  the wording: myexample.com needs to be change to one's own domain.
c. After running 'build', edit the file: index.js in the build directory to change the 'HOST' reference from 0.0.0.0 to 127.0.0.1


