use Mojolicious::Lite -signatures;

use Crypt::Bcrypt::Easy;

plugin Config => {file => 'login-helper.conf', default => {foo => 'fail'}};


# Return configured foo value: 'success', or default 'fail' if no configuration file
get '/foo' => sub ($c) {
  my $foo = $c->app->config('foo');
  $c->render(json => {foo => $foo});
};

#Usage: /create/'name'/'passwd'

get '/create/:name/:passwd' => sub ($c) {
	my $name = $c->param('name') || '';
    my $passwd = $c->param('passwd') || '';
    my $crypted_password = bcrypt->crypt($passwd);
    $c->render(json => {name => $name, passwd => $passwd, password => $crypted_password});

};

# after placing name with passwd in .conf file. use /verify/'name'/'passwd'
get '/verify/:name/:passwd' => sub ($c) {
	   my $name = $c->param('name') || '';
       my $passwd = $c->param('passwd') || '';
	 my $crypted_password = app->config($name);
	 if (bcrypt->compare(text => $passwd, crypt => $crypted_password)) {
         $c->render(text => 'welcome');
      }else {
	$c->render(text => 'Not welcome');
	};
};

app->start;

