package LoginApp::Controller::Login;
use Mojo::Base 'Mojolicious::Controller', -signatures;

## each subroutine points to a corresponding .html.ep file
sub index ($self) {
	$self->render('index');
}

sub hello ($self) {
   $self->reply->static('index.html');
}

sub aboutus ($self) {
	$self->render('aboutus');
}

sub findus ($self) {
	$self->render('findus');
}

sub loginpgtest1 ($self) {
	$self->render('test1');
}

sub loginpgtest2 ($self) {
	$self->render('test2');
}

sub none ($self) {
	$self->render('none');
}

## the login subroutines
sub loginpg ($self) {
  my $user = $self->param('user') || '';
  my $pass = $self->param('pass') || '';
  return $self->render unless $self->users->check($user, $pass);
  $self->session(user => $user);
  $self->flash(message => 'Thanks for logging in.');
  $self->redirect_to('test1');
}

sub logged_in ($self) {
  return 1 if $self->session('user');
  $self->redirect_to('index');
  return undef;
}

sub logout ($self) {
  $self->session(expires => 1);
  $self->redirect_to('index');
}

1;

