package LoginApp::Model::Users;

use strict;
use warnings;
use experimental qw(signatures);
use Crypt::Bcrypt::Easy;

## both username and password are case-sensitive, username must be unique. Here one can add others or remove in the anonymous hash of $USERS. Example pwd: john: "a123s", george: "Not24Get"
my $USERS = {
  john => '$2a$08$2EW.SAZoZxHTjUVyH1SKGe8EcSUBRZYBdPtNympNhiZpioCtyaGz6',
  george => '$2a$08$g79DQxXpZuGd2djpkFR4AOqQ0H0xaH7sWwqeH5M9qtVCsvx.kaDAC',
	};

sub new ($class) { bless {}, $class } ## assists with the helper: 'users' to 'bless' $USERS
sub check ($self, $user, $pass) {

  # Success
  return 1 if $USERS->{$user} && bcrypt->compare( text => $pass, crypt => $USERS->{$user}), ;
  
  # Fail
  return undef;
}

1;