package LoginApp;
use Mojo::Base 'Mojolicious', -signatures;

## https://github.com/mojolicious/mojo/tree/master/examples/login
## author: Sebastian Riedel
use LoginApp::Model::Users;


sub startup ($self) {

  # Load configuration from config files
  my $config = $self->plugin('NotYAMLConfig');
  my $conf = {
  from    => 'self@myexample.com',
  encoding => 'base64',
  type     => 'text/html',
  how      => 'sendmail',
  howargs  => [ '/usr/sbin/sendmail -t' ],
};
  
  # Configure the application
  $self->secrets($config->{secrets});
  $self->helper(users => sub { state $users = LoginApp::Model::Users->new });

  #mail
  $self->plugin(mail => $conf);
  
  # Configure routes here and their corresponding entries in lib/loginApp/Controller/login.pm 
  my $r = $self->routes;
  
  $r->get('/')->to('login#index')->name('index');
  $r->get('/hello')->to('login#hello')->name('hello');
  $r->get('/aboutus')->to('login#aboutus')->name('aboutus');
  $r->get('/findus')->to('login#findus')->name('finds');
  $r->any('/contactus')->to('login#contactus')->name('contactus');
  $r->any('/loginpg')->to('login#loginpg')->name('login');
  ## /:name is a catch-all
  $r->any('/:name')->to('login#none');

## with the implicit helper:'under' any route declare underneath is only assessable via login.
  my $logged_in = $r->under('/loginpg')->to('login#logged_in');
  $logged_in->get('/test1')->to('login#test1');
  
  $logged_in->get('/test2')->to('login#test2'); ## other private routes can be added here.
  $logged_in->get('/logout')->to('login#logout');
}

1;
