package LoginApp::Controller::Login;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use Email::Valid;

## each subroutine points to a corresponding .html.ep file
sub index ($self) {
	$self->render('index');
}

sub hello ($self) {
   $self->reply->static('index.html');
}

sub aboutus ($self) {
	$self->render('aboutus');
}

sub findus ($self) {
	$self->render('findus');
}

sub rrender {
  my $self = shift;  
  my $data = $self->render_mail('rrender');
}

sub contactus {
	 my $self = shift;
	 my $subject = $self->param('subject') || '';
	 my $data = $self->param('data') || '';
	 my $visitornam = $self->param('visitornam') || '';
	 my $emailadd = $self->param('emailadd') || '';
	 my $address = Email::Valid->address($emailadd);
	 my $checkout = $self->param('checkout') || '';
	 return $self->render('contactus', msg => 'You can email us via this form:') unless $data;
	 
  if(not $checkout == "42") {
   return $self->render('contactus', msg => 'Checkout entry missing or not correct.');
} elsif( not $address) {
   return $self->render('contactus', msg => 'Email entry missing or not correct.');
} elsif( not $visitornam) {
   return $self->render('contactus', msg => 'Name entry missing.');
} else {
   		 $self->mail(
					to       => 'info@myexample.com',
					type     => 'text/html',
					subject  => $subject,
					data     => "$data \<br\>---\<br\>sender- \<b\>$visitornam \<\\b\>at $emailadd",
					);
		 return $self->render('rrender', msg => 'Success!')
}
}

sub loginpgtest1 ($self) {
	$self->render('test1');
}

sub loginpgtest2 ($self) {
	$self->render('test2');
}

sub none ($self) {
	$self->render('none');
}

## the login subroutines
sub loginpg ($self) {
  my $user = $self->param('user') || '';
  my $pass = $self->param('pass') || '';
  return $self->render unless $self->users->check($user, $pass);

  $self->session(user => $user);
  $self->flash(message => 'Thanks for logging in.');
  $self->redirect_to('test1');
}

sub logged_in ($self) {
  return 1 if $self->session('user');
  $self->redirect_to('index');
  return undef;
}

sub logout ($self) {
  $self->session(expires => 1);
  $self->redirect_to('index');
}

1;


