package LoginApp::Model::Users;

use strict;
use warnings;
use experimental qw(signatures);

use Mojo::Util qw(secure_compare);

## both username and password are case-sensitive, username must be unique. Here one can add others or remove in the anonymous hash of $USERS.
my $USERS = {
	joel => 'las3rs', 
	marcus => 'lulz', 
	sebastian => 'secr3t'
	};

sub new ($class) { bless {}, $class } ## assists with the helper: 'users' to 'bless' $users

sub check ($self, $user, $pass) {

  # Success
  return 1 if $USERS->{$user} && secure_compare $USERS->{$user}, $pass;

  # Fail
  return undef;
}

1;