package LoginApp::Controller::Login;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use Crypt::Bcrypt::Easy;
use Email::Valid;

## each subroutine points to a corresponding .html.ep file
sub index ($c) {
	$c->render('index');
}
  
sub hello ($c) {
   $c->reply->static('index.html');
}

sub aboutus ($c) {
	$c->render('aboutus');
}

sub findus ($c) {
	$c->render('findus');
}

sub rrender {
  my $self = shift;  
  my $data = $self->render_mail('rrender');
}

sub contactus {
	 my $self = shift;
	 my $subject = $self->param('subject') || '';
	 my $data = $self->param('data') || '';
	 my $visitornam = $self->param('visitornam') || '';
	 my $emailadd = $self->param('emailadd') || '';
	 my $address = Email::Valid->address($emailadd);
	 my $checkout = $self->param('checkout') || '';
	 return $self->render('contactus', msg => 'You can email us via this form:') unless $data;
	 
  if(not $checkout == "42") {
   return $self->render('contactus', msg => 'Checkout entry missing or not correct.');
} elsif( not $address) {
   return $self->render('contactus', msg => 'Email entry missing or not correct.');
} elsif( not $visitornam) {
   return $self->render('contactus', msg => 'Name entry missing.');
} else {
   		 $self->mail(
					to       => 'info@myexample.com',
					type     => 'text/html',
					subject  => $subject,
					data     => "$data \<br\>---\<br\>sender- \<b\>$visitornam \<\\b\>at $emailadd",
					);
		 return $self->render('rrender', msg => 'Success!')
}
}

sub loginpgtest1 ($c) {
	$c->render('test1');
}

sub loginpgtest2 ($c) {
	$c->render('test2');
}

sub none ($c) {
	$c->render('none');
}

sub loginpg ($c) {
  $c->render(template => 'login/loginpg', title => 'Login');
};
## the login subroutines
sub member ($c) {
  my $nbr = $c->param('nbr') || '';
  my $passwd = $c->param('pass') || '';
  my $member = $c->app->config('members'); 
  my $member_no = $member->{'member'.$nbr};
  my $member_name = $member_no->{'username'};
  my $member_role = $member_no->{'role'};
  my $member_pwdc = $member_no->{'password'} || '$2a$08$cglMlDL1MfcxLzgnqsHiVenrH8HrevEvBO4CH/lAh7Mzun2Sa4vMu';
  return $c->render (template => 'login/loginpg') unless ($member_no && bcrypt->compare(text => $passwd, crypt => $member_pwdc));
  $c->session(member_name => $member_name);
  $c->flash(message => 'Thanks for logging in.');
  $c->redirect_to('test1');
}

sub logged_in ($c) {
  return 1 if $c->session('member_name');
  $c->redirect_to('index');
  return undef;
}

sub logout ($c) {
  $c->session(expires => 1);
  $c->redirect_to('index');
}

1;

