#initialize====
import os
from flask import Flask
from flask import url_for, redirect, render_template, request, flash
from flask_mail import Mail, Message
from flask_wtf import Form
from wtforms import StringField, TextAreaField, SubmitField, validators, ValidationError, IntegerField


#This file contains most of the configuration variables that your app needs.
basedir = os.path.abspath(os.path.dirname(__file__))
app = Flask(__name__)
mail = Mail(app)
# email server
app.config['MAIL_SERVER']='mail.example.com'
app.config['MAIL_PORT'] = 25
app.config['MAIL_USERNAME'] = 'info@example.com'
app.config['MAIL_PASSWORD'] = 'yourPasswd'
app.config['MAIL_USE_TLS'] = False
app.config['MAIL_USE_SSL'] = False

app.config['WTF_CSRF_ENABLED'] = True
app.config['SECRET_KEY'] = 'Sue^s62day-and-she^sHappy!'

#views=====
@app.route('/')
@app.route('/index')
def index():
	title = 'Welcome'
	return render_template('index.html', title = title)

@app.route('/aboutus')
def aboutus():
	title = 'About Us'
	return render_template('aboutus.html', title = title)

# Change these setting in the route contactus()
# sender 'info@example.com
# recipients ['info@example.com']  	note:sepated with a comma, other addresses can be added.
@app.route('/contactus', methods=['GET', 'POST'])
def contactus():
    form = ContactForm(csrf_enabled=False)
    title = 'ContactUs'

    if request.method == 'POST':
        if form.validate() == False:
            flash('ERROR: Please fill in all fields, with a correct email address and type 42 in checkout')
            return redirect(url_for('contactus'))
        else:
            msg = Message("Message from your visitor " + form.name.data,
                          sender='info@example.com',
                          recipients= ['info@example.com'])
            msg.body = """
            From: %s <%s>,
            %s
            """ % (form.name.data, form.email.data, form.message.data)
            mail.send(msg)
            flash('Successfully  sent message')
            return redirect(url_for('contactus'))
    elif request.method == 'GET':
        return render_template('contactus.html', form=form, title = title)
	
@app.errorhandler(404)
def not_found_error(error):
	return render_template('404.html'), 404
#views====end
#form=====
def CheckNameLength(form, field):
  if len(field.data) < 4:
    raise ValidationError('Name must have more then 3 characters')
	
def is_42(form, field):
    if field.data != 42:
        raise ValidationError('Must be 42') ## number can be changed, also in contactus.html
	
class ContactForm(Form):
    name = StringField('Your Name:', [validators.DataRequired(), CheckNameLength])
    email = StringField('Your e-mail address:', [validators.DataRequired(), validators.Email('your@email.com')])
    message = TextAreaField('Your message:', [validators.DataRequired()])
    checkout = IntegerField('Checkout: Type in as numbers, forty two', [validators.DataRequired(), is_42]) 
    submit = SubmitField('Send Message')
#form=====end	
#run, with debug "On", the app on http://localhost:5000
if __name__ == "__main__":
    app.run(host='0.0.0.0', debug=True)